<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class Ginventarios extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
            'dotacion',
            'cantidad',
            'subcategoria_id',
    ];

    public function subcategorias(): BelongsTo
    {
        return $this->belongsTo(Gsubcategorias::class,'subcategoria_id');
    }

    public function gsubcategoria()
    {
        return $this->belongsTo(Gsubcategorias::class, 'gsubcategoria_id');
    }
}
