<?php

namespace App\Http\Controllers;

use App\Models\sede;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoresedeRequest;
use App\Http\Requests\UpdatesedeRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;

class SedeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $sedes = Sede::all();
        return response()->json($sedes, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoresedeRequest $request)
    {
        try {
            $sede = new sede();
            $sede->fill($request->all());
            $sede->saveOrFail();
            return response()->json(['message' => 'Sede agregado exitosamente', 'product' => $sede], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(sede $sede)
    {
        return response()->json($sede, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(sede $sede)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatesedeRequest $request, sede $sede)
    {
        $sede->fill($request->all());
        if ($sede->save()) {
            return response()->json(['data' => $sede, 'message' => 'La sede se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $sede, 'message' => 'Ha ocurrido un error al actualizar la sede'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(sede $sede)
    {
        $sede->delete();
        return response()->json(['data' => $sede, 'message' => 'La categoria se ha eliminado correctamente'], 200);
    }
}
