angular.module('IDRMAGISOFT').config(['$stateProvider', '$urlRouterProvider', '$locationProvider', '$httpProvider',
    function ($stateProvider, $urlRouterProvider, $locationProvider, $httpProvider) {

        $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';

        $locationProvider.hashPrefix('');
        $urlRouterProvider.otherwise('/');

        $stateProvider.state('index', {
            url: '/',
            templateUrl: 'app/template/Inicio.html',
            controller: 'InitController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [
                                    'css/Inicio.css',
                                    'app/controller/InitController.js'
                                ]
                            }
                        ]);
                    }]
            }

        }).state('Sercivios', {
            url: '/Sercivios',
            templateUrl: 'app/template/Sercivios.html',
            controller: 'SerciviosController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [
                                    'css/Sercivios.css',
                                    'app/controller/SerciviosController.js?v1'
                                ]
                            }
                        ]);
                    }]
            }
        }).state('Subservicios', {
            url: '/Subservicios',
            templateUrl: 'app/template/Subservicios.html',
            controller: 'SubserviciosController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [
                                    'css/Subservicios.css',
                                    'app/controller/SubserviciosController.js'
                                ]
                            }
                        ]);
                    }]
            }
        }).state('Prioridades', {
            url: '/Prioridades',
            templateUrl: 'app/template/Prioridades.html',
            controller: 'PrioridadesController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [
                                    'css/Prioridades.css',
                                    'app/controller/PrioridadesController.js?v1',
                                    'moment.js'
                                ]
                            }
                        ]);
                    }]
            }
        }).state('Cedula', {
            url: '/Cedula',
            templateUrl: 'app/template/Cedula.html',
            controller: 'CedulaController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [
                                    'css/Cedula.css',
                                    'app/controller/CedulaController.js'
                                ]
                            }
                        ]);
                    }]
            }
        }).state('Registro', {
            url: '/Registro',
            templateUrl: 'app/template/Registro.html',
            controller: 'RegistroController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [  
                                    'css/Registro.css',                                  
                                    'app/controller/RegistroController.js'
                                ]
                            }
                        ]);
                    }]
            }
        }).state('Opciones', {
            url: '/Opciones',
            templateUrl: 'app/template/Opciones.html',
            controller: 'OpcionesController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [  
                                    'css/Opciones.css',                                  
                                    'app/controller/OpcionesController.js'
                                ]
                            }
                        ]);
                    }]
            }
        }).state('SelecTipTurn', {
            url: '/SelecTipTurn',
            templateUrl: 'app/template/SelecTipTurn.html',
            controller: 'SelecTipTurnController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                    return $ocLazyLoad.load([
                        {
                            serie: true,
                            files: [  
                                'css/Prioridades.css',                                  
                                'app/controller/SelecTipTurnController.js'
                            ]
                        }
                    ]);
                }]
            }
        }).state('Telefono', {
            url: '/Telefono',
            templateUrl: 'app/template/Telefono.html',
            controller: 'TelefonoController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                    return $ocLazyLoad.load([
                        {
                            serie: true,
                            files: [  
                                'css/Telefono.css',                                  
                                'app/controller/TelefonoController.js'
                            ]
                        }
                    ]);
                }]
            }
        }).state('Previsual', {
            url: '/Previsual',
            templateUrl: 'app/template/Previsual.html',
            controller: 'PrevisualController',
            resolve: {
                deps: ['$ocLazyLoad', function ($ocLazyLoad) {
                        return $ocLazyLoad.load([
                            {
                                serie: true,
                                files: [  
                                    'css/Previsual.css',                                  
                                    'app/controller/PrevisualController.js'
                                ]
                            }
                        ]);
                    }]
            }
        })
    }]);
